﻿# The script of the game goes in this file.

init python:
    import re
    import math
    import json

    from os import listdir
    from os.path import isfile, join
    onlyfiles = [f for f in listdir(config.savedir) if isfile(join(config.savedir, f)) and f.startswith("wincest") ]

    config.keymap['rollback'].append('K_BACKSPACE')

    lexicon = {
        # assegai, songololo, bliksem, ne, hadeda, renosterveld, dumêlang, koppie, boot (car), jersey, naartjie, tshwarelo, ai, jelly tots, shebeen, ee, joh, robot, bless(er|ing), wena, Wimpy, jislaaik, moer
        # seriaas, lekker, daarsy, boet, pap and sheba, che, kief, sosatie, na (right), flat, aikona

        # Along with “braai,” “ja,” “shame,” “sjoe,” “voetsek,” “yho,” and a few others (and variations of these), it appears to be in use in English and other South African languages across the full demographic spectrum.
    }

    patrons = [
        {
            "name": "Bullhead",
            "tier": "Hallboy",
        },
        {
            "name": "Steve Harveys Mustache",
            "tier": "Hallboy",
        },
        {
            "name": "glenn Kraebel",
            "tier": "Hallboy",
        },
        {
            "name": "tranquilSea",
            "tier": "Hallboy",
        },
        {
            "name": "PNM",
            "tier": "Hallboy",
        },
        {
            "name": "MARVOL",
            "tier": "Hallboy",
        },
        {
            "name": "Wandy",
            "tier": "Hallboy",
        },
        {
            "name": "Eric Vega",
            "tier": "Hallboy",
        },
        {
            "name": "Smiling Rabbit",
            "tier": "Footman",
        },
        {
            "name": "lllllll",
            "tier": "Hallboy",
        },
        {
            "name": "Worraps",
            "tier": "Hallboy",
        },
        {
            "name": "Slypask",
            "tier": "Hallboy",
        },
        {
            "name": "Tann",
            "tier": "Hallboy",
        },
        {
            "name": "Dylan Holloway",
            "tier": "Footman",
        },
        {
            "name": "Grimalkin_Wolf",
            "tier": "Hallboy",
        },
        {
            "name": "Connor Wagner",
            "tier": "Footman",
        },
        {
            "name": "SailumX90",
            "tier": "Hallboy",
        },
        {
            "name": "Jack",
            "tier": "Hallboy",
        },
        {
            "name": "J B",
            "tier": "Hallboy",
        },
        {
            "name": "Auriel",
            "tier": "Hallboy",
        },
        {
            "name": "kaerumchn",
            "tier": "Hallboy",
        },
        {
            "name": "",
            "tier": "Hallboy",
        },
        {
            "name": "hyyrdrof",
            "tier": "Hallboy",
        },
        {
            "name": "Tim Janssen",
            "tier": "Hallboy",
        },
        {
            "name": "Wren",
            "tier": "Footman",
        },
        {
            "name": "Relaxed Ninja",
            "tier": "Hallboy",
        },
        {
            "name": "Zebrabear",
            "tier": "Hallboy",
        },
        {
            "name": "Atty",
            "tier": "Hallboy",
        },
        {
            "name": "Husbear",
            "tier": "Hallboy",
        },
        {
            "name": "Citali",
            "tier": "Hallboy",
        },
        {
            "name": "Macan Tiger",
            "tier": "Hallboy",
        },
        {
            "name": "Ardex",
            "tier": "Hallboy",
        },
        {
            "name": "Markus",
            "tier": "Hallboy",
        },
        {
            "name": "Holden",
            "tier": "Hallboy",
        },
        {
            "name": "Jesse Koehler",
            "tier": "Hallboy",
        },
        {
            "name": "memow189",
            "tier": "Hallboy",
        },
        {
            "name": "MetaMan",
            "tier": "Hallboy",
        },
        {
            "name": "KrassTheCow",
            "tier": "Footman",
        },
        {
            "name": "P V",
            "tier": "Hallboy",
        },
        {
            "name": "Jclone",
            "tier": "Hallboy",
        },
        {
            "name": "Fuzzfang",
            "tier": "Hallboy",
        },
        {
            "name": "Shelby46",
            "tier": "Hallboy",
        },
        {
            "name": "Cookieville",
            "tier": "Hallboy",
        },
        {
            "name": "Gene Catspurr",
            "tier": "Hallboy",
        },
        {
            "name": "Akeela",
            "tier": "Footman",
        },
        {
            "name": "Silver",
            "tier": "Hallboy",
        },
        {
            "name": "Lume",
            "tier": "Hallboy",
        },
        {
            "name": "GM",
            "tier": "Footman",
        },
        {
            "name": "Pyrosigma",
            "tier": "Hallboy",
        },
        {
            "name": "Jael",
            "tier": "Hallboy",
        },
        {
            "name": "Taelgaris",
            "tier": "Hallboy",
        },
        {
            "name": "Jamie",
            "tier": "Hallboy",
        },
        {
            "name": "Tim Johnson",
            "tier": "Hallboy",
        },
        {
            "name": "Randomgamer24",
            "tier": "Hallboy",
        },
        {
            "name": "GabrielClyde",
            "tier": "Footman",
        },
        {
            "name": "Red",
            "tier": "Hallboy",
        },
        {
            "name": "Timelord Dragon",
            "tier": "Hallboy",
        },
        {
            "name": "Dane",
            "tier": "Hallboy",
        },
        {
            "name": "ModestJack",
            "tier": "Footman",
        },
        {
            "name": "Executaball",
            "tier": "Hallboy",
        },
        {
            "name": "Dustafyer",
            "tier": "Valet",
        },
        {
            "name": "EquusAz",
            "tier": "Hallboy",
        },
        {
            "name": "equoaurelius",
            "tier": "Hallboy",
        },
        {
            "name": "takom13",
            "tier": "Butler",
        },
        {
            "name": "Arktisk",
            "tier": "Valet",
        },
        {
            "name": "QuickDoggo",
            "tier": "Footman",
        },
        {
            "name": "ganache",
            "tier": "Footman",
        },
        {
            "name": "Dal Frin",
            "tier": "Butler",
        },
    ]

    def get_key(x):
        letter = "E"
        if x["tier"] == "Butler":
            letter = "A"
        if x["tier"] == "Valet":
            letter = "B"
        if x["tier"] == "Coachman":
            letter = "C"
        if x["tier"] == "Footman":
            letter = "D"

        return (letter + x["name"]).lower()

    patrons.sort(key=get_key)

    def getColour(val):
        if val == "Butler":
            return "#ff8000"
        if val == "Valet":
            return "#a335ee"
        if val == "Coachman":
            return "#0070dd"
        if val == "Footman":
            return "#1eff00"

        return "#FFFFFF"

    def hyperlink_lexicon( str_to_test ):

        for keys in lexicon:

            if isinstance(keys, basestring):
                keys = [keys]

            for phrase in keys:
                str_to_test = re.sub(r"([\s\.\-\!\?]){0}([\s\.\-\!\?])".format(phrase), r"\1{{a=lexicon:{phrase}}}{phrase}{{/a}}\2".format(phrase = phrase), str_to_test)

        return str_to_test

    config.say_menu_text_filter = hyperlink_lexicon


    def hyperlink_styler(*args):

        return style.hyperlink_text

    def hyperlink_hovered(*args):

        if not args[0]:
            # Ren'Py 7+ recent nightly only, see below
            renpy.hide_screen("lexicon_popup")

        elif args[0][:8] == "lexicon:":

            renpy.show_screen( "lexicon_popup",
                                args[0][8:],
                                renpy.get_mouse_pos() )

            renpy.restart_interaction()

        return

    def hyperlink_clicked(*args):

        if args[0] and args[0][:8] != 'lexicon:':

            # adapted from common/00defaults.rpy
            if args[0].startswith("http:") or args[0].startswith("https:"):
                try:
                    import webbrowser
                    webbrowser.open(args[0])
                except:
                    renpy.notify("Failed to open browser")

            elif args[0].startswith("jump:"):
                renpy.jump( args[0][5:] )

            else:
                renpy.call_in_new_context(args[0][args[0].index(':')+1:])


    style.default.hyperlink_functions = ( hyperlink_styler,
                                        hyperlink_clicked,
                                        hyperlink_hovered )

    def historyHas(val):
        return history & val == val

screen lexicon_popup(phrase=None, pos=(100,100)):

    if phrase:

        python:
            # get description
            d = [ lexicon[k] for k in lexicon if phrase in k ]
            description = d[0] if len(d) else "No description found."
            description = " ".join( [ k for k in description.split()
                                    if k not in [" ", "\t"] ] )

            # move the ypos up by a bit
            pos = ( pos[0], pos[1] - 25 )

            # reformat phrase
            p = [ k for k in lexicon if phrase in k ]
            primary_phrase = p[0][0] if len(p) else phrase
            if primary_phrase != phrase:
                phrase = "{0} ({1})".format(phrase, primary_phrase)

        frame:
            #background "gui/bg_test.png"
            anchor (0.5, 1.0)
            pos pos
            xsize 340
            background Solid("#E0EBF3")
            vbox:
                text "[phrase]" size 20 color "#000" bold True
                text "[description]" size 15 color "#000"

    # Hacky workaround as hyperlink_hovered does not seem to nicely hide this
    # --- Fixed in Ren'Py 7.0 nightlies of May 23rd onwards apparently

    # timer 0.5 action Hide("lexicon_popup")

default content.wincest = False

python:
    if len(onlyfiles) > 0:
        content.wincest = True

# The game starts here.

label splashscreen:
    scene black
    with Pause(1)

    show splash with dissolve
    with Pause(2)

    scene black with dissolve
    with Pause(1)

    show warning with dissolve
    pause

    scene black with dissolve
    with Pause(1)

    return

label credits:
    scene black
    show screen tbc with dissolve
    pause
    hide screen tbc with dissolve
    show bg credits blur
    show screen endgame with dissolve
    pause
    hide screen endgame with dissolve
    return

label short_end:
    scene black
    show screen shortend with dissolve
    pause
    return

label interludic(which=0):
    scene black
    show screen expression ("interludic" + str(which)) with dissolve
    pause
    hide screen expression ("interludic" + str(which)) with dissolve
    return

label skip_time:
    scene black
    show screen timeskip with dissolve
    pause
    hide screen timeskip
    return

screen interludic1():
    vbox:
        xalign 0.5
        yalign 0.3
        text "Interludic 01":
            size 75
            xalign 0.5

    vbox:
        xalign 0.5
        yalign 0.5

        text "To Touch the Sky":
            xalign 0.5
            size 30

screen tbc():
    vbox:
        xalign 0.5
        yalign 0.3
        text "To be continued...":
            xalign 0.5
            size 50

screen timeskip():
    vbox:
        xalign 0.5
        yalign 0.3
        text "Two Months Later":
            xalign 0.5
            size 50

screen shortend():
    vbox:
        xalign 0.5
        yalign 0.3
        text "The End":
            xalign 0.5
            size 50

    vbox:
        xalign 0.5
        yalign 0.5

        text "...if you'd like it to be. Go back and make a different decision, or leave things there.":
            xalign 0.5
            size 25

screen endgame():
    vbox:
        xalign 0.5
        yalign 0.1
        text "Thanks for reading this build of \"Lord of the Manor\"!" size 40 bold True font "fonts/BubblerOne.ttf"

    vbox:
        xalign 0.5
        yalign 0.2
        text "If you enjoyed it, please consider {a=https://zaggynorse.itch.io/lord-of-the-manor}leaving a vote on Itch{/a} or {a=https://docs.google.com/forms/d/1XBt5W7jbeC-z_492LVSycH4XdWUAU09sobyGIq5kMcE/viewform}filling in my feedback form{/a}. It really helps :)" size 30 font "fonts/BubblerOne.ttf"

    vbox:
        xalign 0.5
        yalign 0.4
        text "Lord of the Manor is made possible by the generous support of the following people on {a=https://www.patreon.com/lordofthemanor}Patreon{/a}:" size 25 font "fonts/BubblerOne.ttf"

    hbox:
        xalign 0.1
        yalign 0.6
        spacing 100

        vbox:
            # text "Current Patrons" bold True text_align 0.5 xoffset 20 yoffset 20 font "fonts/BubblerOne.ttf"
            grid math.ceil(math.sqrt(len(patrons))) math.ceil(math.sqrt(len(patrons))) spacing 10 yoffset 70:
                for x in patrons:
                    text x["name"] color getColour(x["tier"]) size 25 font "fonts/BubblerOne.ttf"
                for x in range(int(math.ceil(math.sqrt(len(patrons)))*math.ceil(math.sqrt(len(patrons)))) - len(patrons)):
                    text " " size 20


label start:

    scene bg generic

    jump lbl_1_0.opening