﻿## This file contains options that can be changed to customize your game.
##
## Lines beginning with two '#' marks are comments, and you shouldn't uncomment
## them. Lines beginning with a single '#' mark are commented-out code, and you
## may want to uncomment them when appropriate.


## Basics ######################################################################

## A human-readable name of the game. This is used to set the default window
## title, and shows up in the interface and error reports.
##
## The _() surrounding the string marks it as eligible for translation.

define config.name = _("Lord of the Manor")


## Determines if the title given above is shown on the main menu screen. Set
## this to False to hide the title.

define gui.show_name = False


## The version of the game.

define config.version = "0.5.5"

define config.developer = "auto"


## Text that is placed on the game's about screen. Place the text between the
## triple-quotes, and leave a blank line between paragraphs.

define gui.about = """"Bad Dragon", "Chance", "Clayton" and "Rowan" are copyright Bad Dragon.

Glitter Blast by Kevin MacLeod
Link: https://incompetech.filmmusic.io/song/4707-glitter-blast
License: https://filmmusic.io/standard-license
"""

define gui.changelog = """
{b}{u}v0.5.5 (30 May 2023){/u}{/b}

{b}-{/b} Reworked Ta'kom interaction on Day 1.
{b}-{/b} Added missing BG for Zef sex scene.
{b}-{/b} Reworked various parts of Babbelas route to improve his voice.
{b}-{/b} Lowered the intensity of the Babbelas sex scene to leave room for the future.
{b}-{/b} Miscellaneous grammar and spelling fixes.
{b}-{/b} Added a new scene to Interludic 1 to give us more insight into who Nero is and what he and Ataxion are like together.
{b}-{/b} Quite a lot of editing for the very final scene to introduce key information at a better pace and make Kierie more in line with my goals for him, as well as a key new moment with Ta'kom.

{b}{u}v0.5.2 (2 April 2023){/u}{/b}

{b}-{/b} Fixed crash in no-party route while trying Chance.
{b}-{/b} Fixed comments showing.

{b}{u}v0.5: "Tripping on !nabas" (26 March 2023){/u}{/b}

{b}-{/b} Finished third day (and thus the entire introduction). New words: ~90,000.
{b}-{/b} Started using new text formatting, with inline dialogue tags for more expressive scenes.
{b}-{/b} Added introduction for Xhenxe.
{b}-{/b} Added encounters (or introductions, if you've not met them) with: Ta'kom, Nabo, Rhangani, Suri, Advik, Viraj, Dalarius, Kierie and Werner.
{b}-{/b} Corrections for Rav, who loved being a hare so much he still was one in some places.
{b}-{/b} Editing improvements to past scenes.
{b}-{/b} Prepared things for the meat of the game.

{b}{u}v0.4: "Horse Humour" (12 August 2022){/u}{/b}

{b}-{/b} Finished entire second day. New words: ~60,000.
{b}-{/b} Improvements to ugazi introduction to better explain what the impact is.
{b}-{/b} Added encounter with Ta'kom.
{b}-{/b} Added introduction/encounter with Werner.
{b}-{/b} Added Babbelas route & sex scene.
{b}-{/b} Name change: Banga -> Rhangani.
{b}-{/b} Finished Rhangani introduction.
{b}-{/b} Added Jags route.
{b}-{/b} Finished Zef route & sex scene.
{b}-{/b} Added Nabo introduction.
{b}-{/b} Added Dalarius introduction.
{b}-{/b} Spelling corrections across the game.

{b}{u}v0.3.5: "Ossicones" (3 September 2021){/u}{/b}

{b}-{/b} Added encounter with Fanayo.
{b}-{/b} Added scene with Ta'kom*.
{b}-{/b} Added scene with Werner.
{b}-{/b} Introduced Babbelas*.
{b}-{/b} Introduced Rhangani*.
{b}-{/b} Added introduction/sex scene with Zef*.
{b}-{/b} Introduced Jags*.
"""


## A short name for the game used for executables and directories in the built
## distribution. This must be ASCII-only, and must not contain spaces, colons,
## or semicolons.

define build.name = "LordoftheManor"


## Sounds and music ############################################################

## These three variables control which mixers are shown to the player by
## default. Setting one of these to False will hide the appropriate mixer.

define config.has_sound = False
define config.has_music = True
define config.has_voice = False

define config.default_music_volume = 0.3


## To allow the user to play a test sound on the sound or voice channel,
## uncomment a line below and use it to set a sample sound to play.

# define config.sample_sound = "sample-sound.ogg"
# define config.sample_voice = "sample-voice.ogg"


## Uncomment the following line to set an audio file that will be played while
## the player is at the main menu. This file will continue playing into the
## game, until it is stopped or another file is played.

define config.main_menu_music = "music/1_0 upbeat.mp3"


## Transitions #################################################################
##
## These variables set transitions that are used when certain events occur.
## Each variable should be set to a transition, or None to indicate that no
## transition should be used.

## Entering or exiting the game menu.

define config.enter_transition = dissolve
define config.exit_transition = dissolve


## Between screens of the game menu.

define config.intra_transition = dissolve


## A transition that is used after a game has been loaded.

define config.after_load_transition = Dissolve(1.0)
define config.end_splash_transition = Dissolve(0.5)


## Used when entering the main menu after the game has ended.

define config.end_game_transition = None


## A variable to set the transition used when the game starts does not exist.
## Instead, use a with statement after showing the initial scene.


## Window management ###########################################################
##
## This controls when the dialogue window is displayed. If "show", it is always
## displayed. If "hide", it is only displayed when dialogue is present. If
## "auto", the window is hidden before scene statements and shown again once
## dialogue is displayed.
##
## After the game has started, this can be changed with the "window show",
## "window hide", and "window auto" statements.

define config.window = "auto"


## Transitions used to show and hide the dialogue window

define config.window_show_transition = Dissolve(.2)
define config.window_hide_transition = Dissolve(.2)


## Preference defaults #########################################################

## Controls the default text speed. The default, 0, is infinite, while any other
## number is the number of characters per second to type out.

default preferences.text_cps = 0


## The default auto-forward delay. Larger numbers lead to longer waits, with 0
## to 30 being the valid range.

default preferences.afm_time = 15


## Save directory ##############################################################
##
## Controls the platform-specific place Ren'Py will place the save files for
## this game. The save files will be placed in:
##
## Windows: %APPDATA\RenPy\<config.save_directory>
##
## Macintosh: $HOME/Library/RenPy/<config.save_directory>
##
## Linux: $HOME/.renpy/<config.save_directory>
##
## This generally should not be changed, and if it is, should always be a
## literal string, not an expression.

define config.save_directory = "LordoftheManor-1607185681"


## Icon ########################################################################
##
## The icon displayed on the taskbar or dock.

define config.window_icon = "gui/window_icon.png"


## Build configuration #########################################################
##
## This section controls how Ren'Py turns your project into distribution files.

init python:

    ## The following functions take file patterns. File patterns are case-
    ## insensitive, and matched against the path relative to the base directory,
    ## with and without a leading /. If multiple patterns match, the first is
    ## used.
    ##
    ## In a pattern:
    ##
    ## / is the directory separator.
    ##
    ## * matches all characters, except the directory separator.
    ##
    ## ** matches all characters, including the directory separator.
    ##
    ## For example, "*.txt" matches txt files in the base directory, "game/
    ## **.ogg" matches ogg files in the game directory or any of its
    ## subdirectories, and "**.psd" matches psd files anywhere in the project.

    ## Classify files as None to exclude them from the built distributions.

    build.classify('**~', None)
    build.classify('**.bak', None)
    build.classify('**/.**', None)
    build.classify('**/#**', None)
    build.classify('**/thumbs.db', None)

    ## To archive files, classify them as 'archive'.

    # build.classify('game/**.png', 'archive')
    # build.classify('game/**.jpg', 'archive')

    ## Files matching documentation patterns are duplicated in a mac app build,
    ## so they appear in both the app and the zip file.

    build.documentation('*.html')
    build.documentation('*.txt')

    build.destination = "Builds"

## Set this to a string containing your Apple Developer ID Application to enable
## codesigning on the Mac. Be sure to change it to your own Apple-issued ID.

# define build.mac_identity = "Developer ID Application: Guy Shy (XHTE5H7Z42)"


## A Google Play license key is required to download expansion files and perform
## in-app purchases. It can be found on the "Services & APIs" page of the Google
## Play developer console.

# define build.google_play_key = "..."


## The username and project name associated with an itch.io project, separated
## by a slash.

# define build.itch_project = "renpytom/test-project"
